using System;
using System.Collections.Generic;
using System.Linq;
using System.Numerics;

public class BakiSrecko
{
    public class Move
    {
        public int Index { get; set; }
        public long X { get; set; }
        public long Y { get; set; }
        public double Angle { get; set; }
    }

    public static void Solve()
    {
        System.Threading.Thread.CurrentThread.CurrentCulture = System.Globalization.CultureInfo.InvariantCulture;
        
        if (!int.TryParse(Console.ReadLine(), out int N)) return;

        List<Move> moves = new List<Move>();
        for (int i = 0; i < N; i++)
        {
            string[] line = Console.ReadLine().Split(' ');
            long x = long.Parse(line[0]);
            long y = long.Parse(line[1]);

            moves.Add(new Move
            {
                Index = i + 1,
                X = x,
                Y = y,
                Angle = Math.Atan2(y, x) 
            });
        }

        if (N == 0)
        {
            Console.WriteLine(0);
            Console.WriteLine();
            return;
        }

        moves.Sort((a, b) => a.Angle.CompareTo(b.Angle));

        List<Move> doubledMoves = new List<Move>(N * 2);
        for (int i = 0; i < N; i++)
        {
            doubledMoves.Add(moves[i]);
        }
        for (int i = 0; i < N; i++)
        {
            doubledMoves.Add(new Move
            {
                Index = moves[i].Index,
                X = moves[i].X,
                Y = moves[i].Y,
                Angle = moves[i].Angle + 2 * Math.PI 
            });
        }

        BigInteger maxDistSq = -1;
        List<int> bestIndices = new List<int>();

        long currentX = 0;
        long currentY = 0;
        int start = 0;
        
        for (int end = 0; end < 2 * N; end++)
        {
            currentX += doubledMoves[end].X;
            currentY += doubledMoves[end].Y;

            while (end > start)
            {
                long nextX = currentX - doubledMoves[start].X;
                long nextY = currentY - doubledMoves[start].Y;

                BigInteger currentDistSq = (BigInteger)currentX * currentX + (BigInteger)currentY * currentY;
                BigInteger nextDistSq = (BigInteger)nextX * nextX + (BigInteger)nextY * nextY;

                if (nextDistSq > currentDistSq)
                {
                    currentX = nextX;
                    currentY = nextY;
                    start++;
                }
                else
                {
                    break;
                }
            }
            
            BigInteger distSq = (BigInteger)currentX * currentX + (BigInteger)currentY * currentY;
            
            if (distSq > maxDistSq)
            {
                maxDistSq = distSq;
                bestIndices.Clear();
                
                for (int k = start; k <= end; k++)
                {
                    bestIndices.Add(doubledMoves[k].Index);
                }
            }
        }
        
        bestIndices = bestIndices.Distinct().ToList();

        Console.WriteLine(bestIndices.Count);
        Console.WriteLine(string.Join(" ", bestIndices));
    }

    public static void Main(string[] args)
    {
        Solve();
    }
}